/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.RouteDefinition;

public class PropertiesComponentEndpointTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testPropertiesComponentEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentEndpoints() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("{{cool.start}}").to("log:{{cool.start}}?showBodyType=false&showExchangeId={{cool.showid}}")).to("mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:{{cool.result}}").expectedMessageCount(1);
        this.template.sendBody("{{cool.start}}", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentMandatory() throws Exception {
        this.context.removeComponent("properties");
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("{{cool.start}}").to("log:{{cool.start}}?showBodyType=false&showExchangeId={{cool.showid}}")).to("mock:{{cool.result}}");
                }
            });
            this.context.start();
            PropertiesComponentEndpointTest.fail((String)"Should throw exception");
        }
        catch (RuntimeCamelException e) {
            IllegalArgumentException cause = PropertiesComponentEndpointTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            String msg = "PropertiesComponent with name properties must be defined in CamelContext to support property placeholders.";
            PropertiesComponentEndpointTest.assertTrue((boolean)cause.getMessage().startsWith(msg));
        }
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        context.addComponent("properties", (Component)pc);
        return context;
    }
}

