/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;

public class PropertiesComponentGetOrElseTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testPropertiesComponentFoundKey() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:{{cool.end:mock:wrong}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentUseDefaultValue() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:{{unknown:mock:result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentSimpleLanguage() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().simple("Hi ${body} do you think ${properties:cool.name} rocks?");
            }
        });
        this.context.start();
        String reply = (String)this.template.requestBody("direct:start", (Object)"Claus", String.class);
        PropertiesComponentGetOrElseTest.assertEquals((String)"Hi Claus do you think Camel rocks?", (String)reply);
    }

    public void testPropertiesComponentSimpleLanguageUsingDefaultValue() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().simple("Hi ${body} do you think ${properties:unknown:Beer} rocks?");
            }
        });
        this.context.start();
        String reply = (String)this.template.requestBody("direct:start", (Object)"Claus", String.class);
        PropertiesComponentGetOrElseTest.assertEquals((String)"Hi Claus do you think Beer rocks?", (String)reply);
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addComponent("properties", (Component)new PropertiesComponent("classpath:org/apache/camel/component/properties/myproperties.properties"));
        return context;
    }
}

