/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.FileOutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.properties.PropertiesComponent;

public class PropertiesComponentLoadPropertiesFromFileTrimValuesTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.deleteDirectory("target/space");
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.createDirectory("target/space");
        super.setUp();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        FileOutputStream fos = new FileOutputStream("target/space/space.properties");
        String cool = "cool.leading= Leading space" + LS + "cool.trailing=Trailing space " + LS + "cool.both= Both leading and trailing space ";
        fos.write(cool.getBytes());
        fos.write(LS.getBytes());
        String space = "space.leading=   \\r\\n" + LS + "space.trailing=\\t   " + LS + "space.both=  \\r   \\t  \\n   ";
        fos.write(space.getBytes());
        fos.write(LS.getBytes());
        String mixed = "mixed.leading=   Leading space\\r\\n" + LS + "mixed.trailing=Trailing space\\t   " + LS + "mixed.both=  Both leading and trailing space\\r   \\t  \\n   ";
        fos.write(mixed.getBytes());
        fos.write(LS.getBytes());
        String empty = "empty.line=                               ";
        fos.write(empty.getBytes());
        fos.close();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("file:target/space/space.properties");
        context.addComponent("properties", (Component)pc);
        return context;
    }

    public void testMustTrimValues() throws Exception {
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"Leading space", (String)this.context.resolvePropertyPlaceholders("{{cool.leading}}"));
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"Trailing space", (String)this.context.resolvePropertyPlaceholders("{{cool.trailing}}"));
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"Both leading and trailing space", (String)this.context.resolvePropertyPlaceholders("{{cool.both}}"));
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"\r\n", (String)this.context.resolvePropertyPlaceholders("{{space.leading}}"));
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"\t", (String)this.context.resolvePropertyPlaceholders("{{space.trailing}}"));
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"\r   \t  \n", (String)this.context.resolvePropertyPlaceholders("{{space.both}}"));
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"Leading space\r\n", (String)this.context.resolvePropertyPlaceholders("{{mixed.leading}}"));
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"Trailing space\t", (String)this.context.resolvePropertyPlaceholders("{{mixed.trailing}}"));
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"Both leading and trailing space\r   \t  \n", (String)this.context.resolvePropertyPlaceholders("{{mixed.both}}"));
        PropertiesComponentLoadPropertiesFromFileTrimValuesTest.assertEquals((String)"", (String)this.context.resolvePropertyPlaceholders("{{empty.line}}"));
    }
}

