/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;

public class PropertiesComponentSimpleLanguageTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testPropertiesComponentSimpleLanguage() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().simple("Hi ${body} do you think ${properties:cheese.quote}?");
            }
        });
        this.context.start();
        String reply = (String)this.template.requestBody("direct:start", (Object)"Claus", String.class);
        PropertiesComponentSimpleLanguageTest.assertEquals((String)"Hi Claus do you think Camel rocks?", (String)reply);
    }

    public void testPropertiesComponentDualSimpleLanguage() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().simple("Hi ${body} do you think ${properties:cheese.quote}? And do you like ${properties:cheese.type} cheese?");
            }
        });
        this.context.start();
        String reply = (String)this.template.requestBody("direct:start", (Object)"Claus", String.class);
        PropertiesComponentSimpleLanguageTest.assertEquals((String)"Hi Claus do you think Camel rocks? And do you like Gouda cheese?", (String)reply);
    }

    public void testPropertiesComponentSimpleLanguageWithLocations() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().simple("Hi ${body}. ${properties-location:org/apache/camel/component/properties/bar.properties:bar.quote}.");
            }
        });
        this.context.start();
        String reply = (String)this.template.requestBody("direct:start", (Object)"Claus", String.class);
        PropertiesComponentSimpleLanguageTest.assertEquals((String)"Hi Claus. Beer taste good.", (String)reply);
    }

    public void testNoExistingPropertiesComponentWithLocation() throws Exception {
        this.context.removeComponent("properties");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().simple("Hi ${body}. ${properties-location:org/apache/camel/component/properties/bar.properties:bar.quote}.");
            }
        });
        this.context.start();
        String reply = (String)this.template.requestBody("direct:start", (Object)"Claus", String.class);
        PropertiesComponentSimpleLanguageTest.assertEquals((String)"Hi Claus. Beer taste good.", (String)reply);
    }

    public void testNoExistingPropertiesComponentWithLocations() throws Exception {
        this.context.removeComponent("properties");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().simple("Hi ${body}. ${properties-location:org/apache/camel/component/properties/bar.properties,org/apache/camel/component/properties/cheese.properties:cheese.quote}.");
            }
        });
        this.context.start();
        String reply = (String)this.template.requestBody("direct:start", (Object)"Claus", String.class);
        PropertiesComponentSimpleLanguageTest.assertEquals((String)"Hi Claus. Camel rocks.", (String)reply);
    }

    public void testNoExistingPropertiesComponentWithoutLocation() throws Exception {
        this.context.removeComponent("properties");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().simple("Hi ${body} do you think ${properties:cheese.quote}?");
            }
        });
        this.context.start();
        try {
            this.template.requestBody("direct:start", (Object)"Claus", String.class);
            PropertiesComponentSimpleLanguageTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            RuntimeCamelException rce = PropertiesComponentSimpleLanguageTest.assertIsInstanceOf(RuntimeCamelException.class, e.getCause());
            IllegalArgumentException iae = PropertiesComponentSimpleLanguageTest.assertIsInstanceOf(IllegalArgumentException.class, rce.getCause());
            PropertiesComponentSimpleLanguageTest.assertEquals((String)"PropertiesComponent with name properties must be defined in CamelContext to support property placeholders in expressions", (String)iae.getMessage());
        }
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:org/apache/camel/component/properties/cheese.properties");
        context.addComponent("properties", (Component)pc);
        return context;
    }
}

