/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.RouteDefinition;

public class PropertiesComponentTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testPropertiesComponent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:{{cool.end}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentTwo() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:{{cool.end}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentCustomTokens() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setPrefixToken("[[");
        pc.setSuffixToken("]]");
        PropertiesComponentTest.assertEquals((String)"[[", (String)pc.getPrefixToken());
        PropertiesComponentTest.assertEquals((String)"]]", (String)pc.getSuffixToken());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:[[cool.end]]");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        pc.setPrefixToken(null);
        pc.setSuffixToken(null);
        PropertiesComponentTest.assertEquals((String)"{{", (String)pc.getPrefixToken());
        PropertiesComponentTest.assertEquals((String)"}}", (String)pc.getSuffixToken());
    }

    public void testPropertiesComponentTemplate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:cool").to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("{{cool.start}}", (Object)"Hello World");
        this.template.sendBody("{{cool.start}}", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentResult() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentMockMock() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:{{cool.mock}}:{{cool.mock}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:mock").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentConcat() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool.concat");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentLocationOverride() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:{{bar.end}}?locations=org/apache/camel/component/properties/bar.properties");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentLocationsOverride() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:bar.end?locations=org/apache/camel/component/properties/bar.properties");
                this.from("direct:cheese").to("properties:cheese.end?locations=org/apache/camel/component/properties/bar.properties,classpath:org/apache/camel/component/properties/cheese.properties");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:cheese").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:cheese", (Object)"Hello Cheese");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentInvalidKey() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:{{foo.unknown}}");
            }
        });
        try {
            this.context.start();
            PropertiesComponentTest.fail((String)"Should throw exception");
        }
        catch (FailedToCreateRouteException e) {
            ResolveEndpointFailedException cause = PropertiesComponentTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            IllegalArgumentException iae = PropertiesComponentTest.assertIsInstanceOf(IllegalArgumentException.class, cause.getCause());
            PropertiesComponentTest.assertEquals((String)"Property with key [foo.unknown] not found in properties from text: {{foo.unknown}}", (String)iae.getMessage());
        }
    }

    public void testPropertiesComponentCircularReference() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool.a");
            }
        });
        try {
            this.context.start();
            PropertiesComponentTest.fail((String)"Should throw exception");
        }
        catch (FailedToCreateRouteException e) {
            ResolveEndpointFailedException cause = PropertiesComponentTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            IllegalArgumentException iae = PropertiesComponentTest.assertIsInstanceOf(IllegalArgumentException.class, cause.getCause());
            PropertiesComponentTest.assertEquals((String)"Circular reference detected with key [cool.a] from text: {{cool.a}}", (String)iae.getMessage());
        }
    }

    public void testPropertiesComponentCacheDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:{{cool.end}}");
                this.from("direct:foo").to("properties:mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentCacheDisabled() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setCache(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool.end");
                this.from("direct:foo").to("properties:mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentPropertyPrefix() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setPropertyPrefix("cool.");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:end");
                this.from("direct:foo").to("properties:mock:{{result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentParameterizedPropertyPrefix() throws Exception {
        System.setProperty("myPrefix", "cool");
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setPropertyPrefix("${myPrefix}.");
        pc.setPropertySuffix(".xx");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:end");
                this.from("direct:foo").to("properties:mock:{{result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
        System.clearProperty("myPrefix");
    }

    public void testPropertiesComponentPropertyPrefixFallbackDefault() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setPropertyPrefix("cool.");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool.end");
                this.from("direct:foo").to("properties:mock:{{result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentPropertyPrefixFallbackDefaultNotFound() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setPropertyPrefix("cool.");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:doesnotexist");
            }
        });
        try {
            this.context.start();
            PropertiesComponentTest.fail((String)"Should throw exception");
        }
        catch (FailedToCreateRouteException e) {
            ResolveEndpointFailedException cause = PropertiesComponentTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            IllegalArgumentException iae = PropertiesComponentTest.assertIsInstanceOf(IllegalArgumentException.class, cause.getCause());
            PropertiesComponentTest.assertEquals((String)"Property with key [cool.doesnotexist] (and original key [doesnotexist]) not found in properties from text: {{doesnotexist}}", (String)iae.getMessage());
        }
    }

    public void testPropertiesComponentPropertyPrefixFallbackFalse() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setPropertyPrefix("cool.");
        pc.setFallbackToUnaugmentedProperty(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool.end");
                this.from("direct:foo").to("properties:mock:{{result}}");
            }
        });
        try {
            this.context.start();
            PropertiesComponentTest.fail((String)"Should throw exception");
        }
        catch (FailedToCreateRouteException e) {
            ResolveEndpointFailedException cause = PropertiesComponentTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            IllegalArgumentException iae = PropertiesComponentTest.assertIsInstanceOf(IllegalArgumentException.class, cause.getCause());
            PropertiesComponentTest.assertEquals((String)"Property with key [cool.cool.end] not found in properties from text: {{cool.end}}", (String)iae.getMessage());
        }
    }

    public void testPropertiesComponentPropertySuffix() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setPropertySuffix(".end");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentPropertySuffixFallbackDefault() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setPropertySuffix(".end");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool.end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentPropertySuffixFallbackFalse() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setPropertySuffix(".end");
        pc.setFallbackToUnaugmentedProperty(false);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool.end");
            }
        });
        try {
            this.context.start();
            PropertiesComponentTest.fail((String)"Should throw exception");
        }
        catch (FailedToCreateRouteException e) {
            ResolveEndpointFailedException cause = PropertiesComponentTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            IllegalArgumentException iae = PropertiesComponentTest.assertIsInstanceOf(IllegalArgumentException.class, cause.getCause());
            PropertiesComponentTest.assertEquals((String)"Property with key [cool.end.end] not found in properties from text: {{cool.end}}", (String)iae.getMessage());
        }
    }

    public void testJvmSystemPropertyNotFound() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").to("properties:xxx?locations=foo/${xxx}");
                }
            });
            this.context.start();
            PropertiesComponentTest.fail((String)"Should thrown an exception");
        }
        catch (FailedToCreateRouteException e) {
            IllegalArgumentException cause = PropertiesComponentTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
            PropertiesComponentTest.assertEquals((String)"Cannot find JVM system property with key: xxx", (String)cause.getMessage());
        }
    }

    public void testCache() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        PropertiesComponentTest.assertTrue((boolean)pc.isCache());
        PropertiesComponentTest.assertNotNull((Object)pc);
        for (int i = 0; i < 2000; ++i) {
            String uri = pc.parseUri("{{cool.mock}}:" + i);
            PropertiesComponentTest.assertEquals((String)("mock:" + i), (String)uri);
        }
    }

    public void testCacheRoute() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").setBody((Expression)this.simple("${properties:cool.mock}${body}"))).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2000);
        for (int i = 0; i < 2000; ++i) {
            this.template.sendBody("direct:start", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testQuotedPrefix() throws Exception {
        PropertiesComponentTest.assertEquals((String)"mock", (String)this.context.resolvePropertyPlaceholders("{{cool.mock}}"));
        PropertiesComponentTest.assertEquals((String)"'{{' + something + '}}'", (String)this.context.resolvePropertyPlaceholders("'{{' + something + '}}'"));
        PropertiesComponentTest.assertEquals((String)"\"{{\" + something + \"}}\"", (String)this.context.resolvePropertyPlaceholders("\"{{\" + something + \"}}\""));
        PropertiesComponentTest.assertEquals((String)"mock'", (String)this.context.resolvePropertyPlaceholders("{{cool.mock}}'"));
        PropertiesComponentTest.assertEquals((String)"mock\"", (String)this.context.resolvePropertyPlaceholders("{{cool.mock}}\""));
        PropertiesComponentTest.assertEquals((String)"'mock", (String)this.context.resolvePropertyPlaceholders("'{{cool.mock}}"));
        PropertiesComponentTest.assertEquals((String)"\"mock", (String)this.context.resolvePropertyPlaceholders("\"{{cool.mock}}"));
    }

    public void testPropertiesComponentOverride() throws Exception {
        System.setProperty("cool.result", "bar");
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setSystemPropertiesMode(2);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").to("mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
        System.clearProperty("cool.result");
    }

    public void testPropertiesComponentFallback() throws Exception {
        System.setProperty("cool.result", "bar");
        System.setProperty("beer", "Carlsberg");
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setSystemPropertiesMode(1);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:foo").to("mock:{{beer}}")).to("mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:Carlsberg").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
        System.clearProperty("cool.result");
        System.clearProperty("beer");
    }

    public void testPropertiesComponentNever() throws Exception {
        System.setProperty("cool.result", "bar");
        System.setProperty("beer", "Carlsberg");
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setSystemPropertiesMode(0);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:foo").to("mock:{{beer}}")).to("mock:{{cool.result}}");
            }
        });
        try {
            this.context.start();
            PropertiesComponentTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            PropertiesComponentTest.assertEquals((String)"Property with key [beer] not found in properties from text: mock:{{beer}}", (String)e.getCause().getMessage());
        }
        System.clearProperty("cool.result");
        System.clearProperty("beer");
    }

    public void testCamelProperties() throws Exception {
        this.context.getProperties().put("foo", "Hello {{cool.name}}");
        this.context.getProperties().put("bar", "cool.name");
        this.context.start();
        PropertiesComponentTest.assertEquals((String)"Hello Camel", (String)((String)this.context.getProperties().get("foo")));
        PropertiesComponentTest.assertEquals((String)"cool.name", (String)((String)this.context.getProperties().get("bar")));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addComponent("properties", (Component)new PropertiesComponent("classpath:org/apache/camel/component/properties/myproperties.properties"));
        return context;
    }
}

