/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesResolver;

public class PropertiesResolverTest
extends ContextTestSupport {
    public void testPropertiesResolver() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                PropertiesResolverTest.this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                    public void configure() throws Exception {
                        this.from("direct:start").to("properties:foo");
                    }
                });
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("foo");
        pc.setPropertiesResolver((PropertiesResolver)new MyCustomResolver());
        context.addComponent("properties", (Component)pc);
        return context;
    }

    public static class MyCustomResolver
    implements PropertiesResolver {
        public Properties resolveProperties(CamelContext context, boolean ignoreMissingLocation, String ... uri) throws Exception {
            Properties answer = new Properties();
            answer.put("foo", "mock:result");
            return answer;
        }
    }
}

