/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.component.rest.DummyRestProcessorFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;

public class FromRestApiTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        jndi.bind("dummy-rest-api", (Object)new DummyRestProcessorFactory());
        return jndi;
    }

    public void testFromRestModel() throws Exception {
        FromRestApiTest.assertEquals((int)1, (int)this.context.getRestDefinitions().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        FromRestApiTest.assertNotNull((Object)rest);
        FromRestApiTest.assertEquals((String)"/say/hello", (String)rest.getPath());
        FromRestApiTest.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestApiTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        FromRestApiTest.assertEquals((String)"log:hello", (String)to.getUri());
        FromRestApiTest.assertEquals((int)2, (int)this.context.getRoutes().size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost").component("dummy-rest").apiContextPath("/api");
                this.rest("/say/hello").get().to("log:hello");
            }
        };
    }
}

