/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.rest.RestParamType;

public class FromRestDefaultValueTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    public void testDefaultValue() throws Exception {
        this.getMockEndpoint("mock:bye").expectedHeaderReceived("kind", (Object)"customer");
        this.getMockEndpoint("mock:bye").expectedHeaderReceived("kind", (Object)"admin");
        this.template.sendBody("seda:get-say-bye", (Object)"Hello World");
        this.template.sendBodyAndHeader("seda:get-say-bye", (Object)"Bye World", "kind", (Object)"admin");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost").enableCORS(true);
                this.rest("/say/bye").consumes("application/json").get().param().type(RestParamType.query).name("kind").defaultValue("customer").endParam().to("mock:bye");
            }
        };
    }
}

