/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;

public class FromRestGetContentTypeTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    public void testFromRestModelContentType() throws Exception {
        Exchange out = this.template.request("seda:get-say-hello", new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        FromRestGetContentTypeTest.assertNotNull((Object)out);
        FromRestGetContentTypeTest.assertEquals((Object)"{ \"name\" : \"Donald\" }", (Object)out.getOut().getBody());
        FromRestGetContentTypeTest.assertEquals((Object)"application/json", (Object)out.getOut().getHeader("Content-Type"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").produces("application/json").get().to("direct:hello");
                this.from("direct:hello").setBody((Expression)this.constant("{ \"name\" : \"Donald\" }"));
            }
        };
    }
}

