/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerRouteTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerRouteTest.class);
    private MyBean bean = new MyBean();

    public void testSchedulerInvokesBeanMethod() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        this.assertMockEndpointsSatisfied();
        SchedulerRouteTest.assertTrue((String)("Should have fired 2 or more times was: " + this.bean.counter.get()), (this.bean.counter.get() >= 2 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("scheduler://foo?delay=100").log("Fired scheduler")).to(new String[]{"bean:myBean", "mock:result"});
            }
        };
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.bean);
        return answer;
    }

    public static class MyBean {
        public AtomicInteger counter = new AtomicInteger(0);

        public void someMethod() {
            LOG.debug("Invoked someMethod()");
            this.counter.incrementAndGet();
        }
    }
}

