/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.util.ServiceHelper;

public class SedaConsumerSuspendResumeTest
extends ContextTestSupport {
    public void testSuspendResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:bar");
        mock.expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        mock.assertIsSatisfied();
        SedaConsumerSuspendResumeTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("foo").name());
        SedaConsumerSuspendResumeTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("bar").name());
        SedaConsumer consumer = (SedaConsumer)this.context.getRoute("bar").getConsumer();
        ServiceHelper.suspendService((Object)consumer);
        SedaConsumerSuspendResumeTest.assertEquals((String)"Suspended", (String)consumer.getStatus().name());
        this.resetMocks();
        mock.expectedMessageCount(0);
        Thread.sleep(2000L);
        this.template.sendBody("seda:foo", (Object)"B");
        mock.assertIsSatisfied(2000L);
        this.resetMocks();
        mock.expectedMessageCount(1);
        ServiceHelper.resumeService((Object)consumer);
        SedaConsumerSuspendResumeTest.assertEquals((String)"Started", (String)consumer.getStatus().name());
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").routeId("foo").to("seda:bar");
                this.from("seda:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

