/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;

public class SedaInOutChainedTimeoutTest
extends ContextTestSupport {
    public void testSedaInOutChainedTimeout() throws Exception {
        StopWatch watch = new StopWatch();
        try {
            this.template.requestBody("seda:a?timeout=5000", (Object)"Hello World");
            SedaInOutChainedTimeoutTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            ExchangeTimedOutException cause = SedaInOutChainedTimeoutTest.assertIsInstanceOf(ExchangeTimedOutException.class, e.getCause());
            SedaInOutChainedTimeoutTest.assertEquals((long)2000L, (long)cause.getTimeout());
        }
        long delta = watch.stop();
        SedaInOutChainedTimeoutTest.assertTrue((String)("Should be faster than 4000 millis, was: " + delta), (delta < 4000L ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                ((RouteDefinition)((RouteDefinition)this.from("seda:a").to("mock:a")).to("seda:b?timeout=2000")).to("mock:a2");
                ((RouteDefinition)this.from("seda:b").to("mock:b")).delay(3000L).transform().constant((Object)"Bye World");
            }
        };
    }
}

