/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaConsumerNotAvailableException;
import org.junit.Test;

public class SedaNoConsumerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testInOnly() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("seda:foo?timeout=1000");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        this.template.sendBody("direct:start", (Object)"Hello World");
        notify.matches(2L, TimeUnit.SECONDS);
    }

    public void testInOut() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("seda:foo?timeout=1000");
            }
        });
        this.context.start();
        try {
            this.template.requestBody("direct:start", (Object)"Hello World");
            SedaNoConsumerTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            SedaNoConsumerTest.assertIsInstanceOf(ExchangeTimedOutException.class, e.getCause());
        }
    }

    @Test
    public void testFailIfNoConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("seda:foo?failIfNoConsumers=true");
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            SedaNoConsumerTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            SedaNoConsumerTest.assertIsInstanceOf(SedaConsumerNotAvailableException.class, e.getCause());
        }
    }

    @Test
    public void testFailIfNoConsuemerAndMultipleConsumerSetting() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo?failIfNoConsumers=true&multipleConsumers=true").to("mock:foo");
                this.from("seda:foo?failIfNoConsumers=true&multipleConsumers=true").to("mock:bar");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFailIfNoConsumesrAfterConsumersLeave() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo?failIfNoConsumers=true").routeId("stopThisRoute").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo?failIfNoConsumers=true", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stopRoute("stopThisRoute");
        TimeUnit.MILLISECONDS.sleep(100L);
        try {
            this.template.sendBody("seda:foo?failIfNoConsumers=true", (Object)"Hello World");
            SedaNoConsumerTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            SedaNoConsumerTest.assertIsInstanceOf(SedaConsumerNotAvailableException.class, e.getCause());
        }
    }

    @Test
    public void testFailIfNoConsumersWithValidConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:in").to("seda:foo?failIfNoConsumers=true");
                this.from("seda:foo").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConfigOnAConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo?failIfNoConsumers=true").to("log:test");
                this.from("seda:foo").to("log:test2");
            }
        });
        this.context.start();
        Thread.sleep(2000L);
    }
}

