/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.ArrayBlockingQueueFactory;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;

public class SedaQueueFactoryTest
extends ContextTestSupport {
    private final ArrayBlockingQueueFactory<Exchange> arrayQueueFactory = new ArrayBlockingQueueFactory();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        SimpleRegistry simpleRegistry = new SimpleRegistry();
        simpleRegistry.put((Object)"arrayQueueFactory", this.arrayQueueFactory);
        return new DefaultCamelContext((Registry)simpleRegistry);
    }

    public void testArrayBlockingQueueFactory() throws Exception {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:arrayQueue?queueFactory=#arrayQueueFactory", SedaEndpoint.class);
        BlockingQueue queue = endpoint.getQueue();
        SedaQueueFactoryTest.assertIsInstanceOf(ArrayBlockingQueue.class, queue);
    }

    public void testArrayBlockingQueueFactoryAndSize() throws Exception {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:arrayQueue50?queueFactory=#arrayQueueFactory&size=50", SedaEndpoint.class);
        BlockingQueue queue = endpoint.getQueue();
        ArrayBlockingQueue blockingQueue = SedaQueueFactoryTest.assertIsInstanceOf(ArrayBlockingQueue.class, queue);
        SedaQueueFactoryTest.assertEquals((String)"remainingCapacity", (int)50, (int)blockingQueue.remainingCapacity());
    }

    public void testDefaultBlockingQueueFactory() throws Exception {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:linkedQueue", SedaEndpoint.class);
        BlockingQueue queue = endpoint.getQueue();
        SedaQueueFactoryTest.assertIsInstanceOf(LinkedBlockingQueue.class, queue);
    }
}

