/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class SedaWaitForTaskAsPropertyTest
extends ContextTestSupport {
    public void testInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        Exchange out = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.setPattern(ExchangePattern.InOut);
                exchange.setProperty("CamelAsyncWait", (Object)WaitForTaskToComplete.IfReplyExpected);
            }
        });
        SedaWaitForTaskAsPropertyTest.assertEquals((Object)"Bye World", (Object)out.getOut().getBody());
        this.assertMockEndpointsSatisfied();
    }

    public void testInOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        Exchange out = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.setPattern(ExchangePattern.InOnly);
                exchange.setProperty("CamelAsyncWait", (Object)WaitForTaskToComplete.IfReplyExpected);
            }
        });
        SedaWaitForTaskAsPropertyTest.assertEquals((Object)"Hello World", (Object)out.getIn().getBody());
        SedaWaitForTaskAsPropertyTest.assertEquals(null, (Object)out.getOut().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("seda:foo");
                ((RouteDefinition)this.from("seda:foo").transform((Expression)this.constant("Bye World"))).to("mock:result");
            }
        };
    }
}

