/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class SedaWaitForTaskNewerTest
extends ContextTestSupport {
    public void testInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        SedaWaitForTaskNewerTest.assertEquals((String)"Hello World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testInOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        Exchange out = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.setPattern(ExchangePattern.InOnly);
            }
        });
        SedaWaitForTaskNewerTest.assertEquals((Object)"Hello World", (Object)out.getIn().getBody());
        SedaWaitForTaskNewerTest.assertEquals(null, (Object)out.getOut().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("seda:foo?waitForTaskToComplete=Never");
                ((RouteDefinition)this.from("seda:foo?waitForTaskToComplete=Never").transform((Expression)this.constant("Bye World"))).to("mock:result");
            }
        };
    }
}

