/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import javax.xml.validation.SchemaFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.validator.ValidatorComponent;
import org.apache.camel.impl.JndiRegistry;

public class CustomSchemaFactoryFeatureTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry registry = super.createRegistry();
        SchemaFactory mySchemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        mySchemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
        registry.bind("MySchemaFactory", (Object)mySchemaFactory);
        return registry;
    }

    public void testCustomSchemaFactory() throws Exception {
        ValidatorComponent v = new ValidatorComponent();
        v.setCamelContext((CamelContext)this.context);
        v.createEndpoint("validator:org/apache/camel/component/validator/unsecuredSchema.xsd?schemaFactory=#MySchemaFactory");
        try {
            v.createEndpoint("validator:org/apache/camel/component/validator/unsecuredSchema.xsd");
            String jdkVendor = System.getProperty("java.vm.vendor");
            if (jdkVendor != null && (jdkVendor.indexOf("Oracle") > 0 || jdkVendor.indexOf("Sun") > 0)) {
                CustomSchemaFactoryFeatureTest.fail((String)"Expect exception here");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

