/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.net.UnknownHostException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;

public abstract class ValidatorDtdAccessAbstractTest
extends ContextTestSupport {
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;
    protected MockEndpoint unknownHostExceptionEndpoint;
    protected MockEndpoint validEndpoint;
    protected String payloud = this.getPayloudPart("Hello world!");
    protected String ssrfPayloud = "<!DOCTYPE roottag PUBLIC \"-//VSR//PENTEST//EN\" \"http://notexisting/test\">\n" + this.payloud;
    protected String xxePayloud = "<!DOCTYPE updateProfile [<!ENTITY file SYSTEM \"http://notexistinghost/test\">]>\n" + this.getPayloudPart("&file;");
    private final boolean accessExternalDTD;

    public ValidatorDtdAccessAbstractTest(boolean accessExternalDTD) {
        this.accessExternalDTD = accessExternalDTD;
    }

    private String getPayloudPart(String bodyValue) {
        return "<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>" + bodyValue + "</body></mail>";
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.unknownHostExceptionEndpoint = this.resolveMandatoryEndpoint("mock:unknownHostException", MockEndpoint.class);
        this.finallyEndpoint = this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                if (ValidatorDtdAccessAbstractTest.this.accessExternalDTD) {
                    this.getContext().getProperties().put("CamelXmlValidatorAccessExternalDTD", "true");
                }
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("validator:org/apache/camel/component/validator/schema.xsd")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doCatch(UnknownHostException.class).to("mock:unknownHostException")).doFinally().to("mock:finally")).end();
            }
        };
    }
}

