/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.validator.ValidatorDtdAccessAbstractTest;

public class ValidatorDtdAccessOffTest
extends ValidatorDtdAccessAbstractTest {
    public ValidatorDtdAccessOffTest() {
        super(false);
    }

    public void testInvalidMessageWithExternalDTDStringSource() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)this.ssrfPayloud);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.unknownHostExceptionEndpoint, this.finallyEndpoint});
    }

    public void testInvalidMessageWithExternalDTDStreamSource() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        ByteArrayInputStream is = new ByteArrayInputStream(this.ssrfPayloud.getBytes(StandardCharsets.UTF_8));
        this.template.sendBody("direct:start", (Object)is);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.unknownHostExceptionEndpoint, this.finallyEndpoint});
    }

    public void testInvalidMessageXXESourceStream() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        ByteArrayInputStream is = new ByteArrayInputStream(this.xxePayloud.getBytes(StandardCharsets.UTF_8));
        this.template.sendBody("direct:start", (Object)is);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.unknownHostExceptionEndpoint, this.finallyEndpoint});
    }
}

