/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;

public class ValidatorIncludeEncodingRouteTest
extends ContextTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        String body = "<t:text xmlns:t=\"org.text\">\n  <t:sentence>J'aime les cam\u00e9lid\u00e9s</t:sentence>\n</t:text>";
        this.template.sendBody("direct:start", (Object)body);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.finallyEndpoint = this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("validator:org/apache/camel/component/validator/text.xsd")).to("mock:valid")).doCatch(NumberFormatException.class).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        System.err.println("helo " + exchange.getException());
                    }
                })).to("mock:invalid")).doFinally().to("mock:finally")).end();
            }
        };
    }
}

