/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;

public class ValidatorIncludeRouteTest
extends ContextTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        String body = "<p:person user=\"james\" xmlns:p=\"org.person\" xmlns:h=\"org.health.check.person\">\n  <p:firstName>James</p:firstName>\n  <p:lastName>Strachan</p:lastName>\n  <p:city>London</p:city>\n  <h:health>\n      <h:lastCheck>2011-12-23</h:lastCheck>\n      <h:status>OK</h:status>\n  </h:health>\n</p:person>";
        this.template.sendBody("direct:start", (Object)body);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testValidMessageNoHealth() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        String body = "<p:person user=\"hiram\"  xmlns:p=\"org.person\" xmlns:h=\"org.health.check.person\">\n  <p:firstName>Hiram</p:firstName>\n  <p:lastName>Chirino</p:lastName>\n  <p:city>Tampa</p:city>\n</p:person>";
        this.template.sendBody("direct:start", (Object)body);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testValidMessageNoHealthNoNamespace() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        String body = "<p:person user=\"hiram\"  xmlns:p=\"org.person\">\n  <p:firstName>Hiram</p:firstName>\n  <p:lastName>Chirino</p:lastName>\n  <p:city>Tampa</p:city>\n</p:person>";
        this.template.sendBody("direct:start", (Object)body);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testInvalidMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        String body = "<p:person user=\"james\" xmlns:p=\"org.person\" xmlns:h=\"org.health.check.person\">\n  <p:firstName>James</p:firstName>\n  <p:lastName>Strachan</p:lastName>\n  <p:city>London</p:city>\n  <h:health>\n      <h:lastCheck>2011-12-23</h:lastCheck>\n  </h:health>\n</p:person>";
        this.template.sendBody("direct:start", (Object)body);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testInvalidMessageNoHealth() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        String body = "<p:person user=\"james\" xmlns:p=\"org.person\" xmlns:h=\"org.health.check.person\">\n  <p:firstName>James</p:firstName>\n  <p:lastName>Strachan</p:lastName>\n</p:person>";
        this.template.sendBody("direct:start", (Object)body);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testInvalidMessageNoHealthNoNamespace() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        String body = "<p:person user=\"james\" xmlns:p=\"org.person\">\n  <p:firstName>James</p:firstName>\n  <p:lastName>Strachan</p:lastName>\n</p:person>";
        this.template.sendBody("direct:start", (Object)body);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.finallyEndpoint = this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("validator:org/apache/camel/component/validator/person.xsd")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doFinally().to("mock:finally")).end();
            }
        };
    }
}

