/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;

public class VmMultipleConsumersMultipleContextTest
extends ContextTestSupport {
    public void testMultipleVMConsumersSameContext() throws Exception {
        DefaultCamelContext camelContext = new DefaultCamelContext();
        ProducerTemplate producerTemplate = camelContext.createProducerTemplate();
        RouteBuilder builder = new RouteBuilder((CamelContext)camelContext){

            public void configure() throws Exception {
                this.from("vm:producer?multipleConsumers=true").routeId("route1").to("mock:route1");
            }
        };
        RouteBuilder builder2 = new RouteBuilder((CamelContext)camelContext){

            public void configure() throws Exception {
                this.from("vm:producer?multipleConsumers=true").routeId("route2").to("mock:route2");
            }
        };
        camelContext.addRoutes((RoutesBuilder)builder);
        camelContext.addRoutes((RoutesBuilder)builder2);
        camelContext.start();
        MockEndpoint mock1 = (MockEndpoint)camelContext.getEndpoint("mock:route1");
        MockEndpoint mock2 = (MockEndpoint)camelContext.getEndpoint("mock:route2");
        mock1.expectedMessageCount(100);
        mock2.expectedMessageCount(100);
        for (int i = 0; i < 100; ++i) {
            producerTemplate.sendBody("vm:producer?multipleConsumers=true", (Object)i);
        }
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{mock1, mock2});
        camelContext.stop();
    }

    public void testVmMultipleConsumersMultipleContext() throws Exception {
        DefaultCamelContext consumerContext1 = new DefaultCamelContext();
        consumerContext1.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("vm:producer?multipleConsumers=true").routeId("route1").to("mock:route1");
            }
        });
        consumerContext1.start();
        MockEndpoint route1Mock = (MockEndpoint)consumerContext1.getEndpoint("mock:route1");
        route1Mock.expectedMessageCount(100);
        DefaultCamelContext consumerContext2 = new DefaultCamelContext();
        consumerContext2.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("vm:producer?multipleConsumers=true").routeId("route2").to("mock:route2");
            }
        });
        consumerContext2.start();
        MockEndpoint route2Mock = (MockEndpoint)consumerContext2.getEndpoint("mock:route2");
        route2Mock.expectedMessageCount(100);
        for (int i = 0; i < 100; ++i) {
            this.template.sendBody("vm:producer?multipleConsumers=true", (Object)i);
        }
        route1Mock.assertIsSatisfied();
        route2Mock.assertIsSatisfied();
        consumerContext1.stop();
        consumerContext2.stop();
    }

    private CamelContext buildConsumerContext(final String route) throws Exception {
        DefaultCamelContext rc = new DefaultCamelContext();
        rc.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("vm:producer?multipleConsumers=true").routeId(route).to("mock:" + route);
            }
        });
        rc.start();
        return rc;
    }

    public void testVmMultipleConsumersDifferentEndpoints() throws Exception {
        DefaultCamelContext consumerContext1 = new DefaultCamelContext();
        consumerContext1.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("vm:producer?multipleConsumers=true").routeId("route1").to("mock:route1");
            }
        });
        consumerContext1.start();
        MockEndpoint route1Mock = (MockEndpoint)consumerContext1.getEndpoint("mock:route1");
        route1Mock.expectedMessageCount(100);
        DefaultCamelContext consumerContext2 = new DefaultCamelContext();
        consumerContext2.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("vm:foo?multipleConsumers=true").routeId("route2").to("mock:route2");
            }
        });
        consumerContext2.start();
        MockEndpoint route2Mock = (MockEndpoint)consumerContext2.getEndpoint("mock:route2");
        route2Mock.expectedMessageCount(0);
        for (int i = 0; i < 100; ++i) {
            this.template.sendBody("vm:producer?multipleConsumers=true", (Object)i);
        }
        route1Mock.assertIsSatisfied();
        route2Mock.assertIsSatisfied();
        consumerContext1.stop();
        consumerContext2.stop();
    }
}

