/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.vm.AbstractVmTestSupport;
import org.apache.camel.model.RouteDefinition;

public class VmShouldNotUseSameThreadTest
extends AbstractVmTestSupport {
    private static long id;
    private final ThreadLocal<String> local = new ThreadLocal();

    public void testNotUseSameThread() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template2.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("vm:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertNull(VmShouldNotUseSameThreadTest.this.local.get());
                        TestCase.assertNotSame((String)"Thread is should not be same", (Object)id, (Object)Thread.currentThread().getId());
                    }
                })).to("mock:result");
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilderForSecondContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        VmShouldNotUseSameThreadTest.this.local.set("Hello");
                        id = Thread.currentThread().getId();
                    }
                })).to("vm:foo");
            }
        };
    }
}

