/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.vm.AbstractVmTestSupport;
import org.apache.camel.model.RouteDefinition;

public class VmTimeoutIssueTest
extends AbstractVmTestSupport {
    public void testVmTimeoutWithAnotherVm() throws Exception {
        try {
            this.template2.requestBody("vm:start1?timeout=4000", (Object)"Hello");
            VmTimeoutIssueTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            ExchangeTimedOutException cause = VmTimeoutIssueTest.assertIsInstanceOf(ExchangeTimedOutException.class, e.getCause());
            VmTimeoutIssueTest.assertEquals((long)2000L, (long)cause.getTimeout());
        }
    }

    public void testVmTimeoutWithProcessor() throws Exception {
        try {
            this.template2.requestBody("vm:start2?timeout=4000", (Object)"Hello");
            VmTimeoutIssueTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            ExchangeTimedOutException cause = VmTimeoutIssueTest.assertIsInstanceOf(ExchangeTimedOutException.class, e.getCause());
            VmTimeoutIssueTest.assertEquals((long)2000L, (long)cause.getTimeout());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("vm:end").delay(3000L).transform().constant((Object)"Bye World");
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilderForSecondContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                ((RouteDefinition)((RouteDefinition)this.from("vm:start1?timeout=4000").to("log:AFTER_START1")).to("vm:end?timeout=2000")).to("log:AFTER_END");
                ((RouteDefinition)((RouteDefinition)this.from("vm:start2?timeout=4000").to("log:AFTER_START2")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new ExchangeTimedOutException(exchange, 2000L);
                    }
                })).to("log:AFTER_PROCESSOR");
            }
        };
    }
}

