/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class XsltOutputFileDeleteTest
extends ContextTestSupport {
    public void testXsltOutputDeleteFile() throws Exception {
        XsltOutputFileDeleteTest.createDirectory("target/xslt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBodyAndHeader("direct:start", (Object)"<hello>world!</hello>", "CamelXsltFileName", (Object)"target/xslt/xsltme.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/xslt/xsltme.xml");
        XsltOutputFileDeleteTest.assertFalse((String)"File should be deleted", (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/example.xsl?output=file&deleteOutputFile=true")).to("mock:result");
            }
        };
    }
}

