/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.TestBean;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.w3c.dom.Document;

public class XsltRouteTest
extends ContextTestSupport {
    public void testSendStringMessage() throws Exception {
        this.sendMessageAndHaveItTransformed("<mail><subject>Hey</subject><body>Hello world!</body></mail>");
    }

    public void testSendBytesMessage() throws Exception {
        this.sendMessageAndHaveItTransformed("<mail><subject>Hey</subject><body>Hello world!</body></mail>".getBytes());
    }

    public void testSendDomMessage() throws Exception {
        XmlConverter converter = new XmlConverter();
        Document body = converter.toDOMDocument("<mail><subject>Hey</subject><body>Hello world!</body></mail>");
        this.sendMessageAndHaveItTransformed(body);
    }

    private void sendMessageAndHaveItTransformed(Object body) throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", body);
        this.assertMockEndpointsSatisfied();
        List list = endpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        String xml = (String)exchange.getIn().getBody(String.class);
        XsltRouteTest.assertNotNull((String)"The transformed XML should not be null", (Object)xml);
        XsltRouteTest.assertTrue((xml.indexOf("transformed") > -1 ? 1 : 0) != 0);
        XsltRouteTest.assertTrue((xml.indexOf("cheese") > -1 ? 1 : 0) != 0);
        XsltRouteTest.assertTrue((xml.indexOf("<subject>Hey</subject>") > -1 ? 1 : 0) != 0);
        XsltRouteTest.assertTrue((xml.indexOf("<body>Hello world!</body>") > -1 ? 1 : 0) != 0);
        TestBean bean = (TestBean)this.context.getRegistry().lookupByNameAndType("testBean", TestBean.class);
        XsltRouteTest.assertNotNull((Object)bean);
        XsltRouteTest.assertEquals((String)"bean.subject", (String)"Hey", (String)bean.getSubject());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)((RouteDefinition)this.from("direct:start").to("xslt:org/apache/camel/component/xslt/transform.xsl")).multicast().bean((Object)"testBean")).to("mock:result");
            }
        };
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("testBean", (Object)new TestBean());
        return jndi;
    }
}

