/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.XsltUriResolver;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.component.xslt.XsltUriResolverFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.spi.ClassResolver;
import org.junit.Assert;

public class XsltUriResolverFactoryTest
extends ContextTestSupport {
    private JndiRegistry registry;

    public void testConfigurationOnEndpoint() throws Exception {
        String endpointUri = "xslt:xslt/staff/staff.xsl?uriResolverFactory=#uriResolverFactory";
        String directStart = "direct:start";
        this.registry.getContext().unbind("xslt");
        this.execute(endpointUri, directStart);
    }

    public void testConfigurationOnComponent() throws Exception {
        XsltComponent xsltComponent = new XsltComponent();
        xsltComponent.setUriResolverFactory((XsltUriResolverFactory)new CustomXsltUriResolverFactory());
        this.registry.bind("xslt", (Object)xsltComponent);
        String endpointUri = "xslt:xslt/staff/staff.xsl";
        String directStart = "direct:startComponent";
        this.execute(endpointUri, directStart);
    }

    void execute(String endpointUri, String directStart) throws InterruptedException {
        InputStream payloud = XsltUriResolverFactoryTest.class.getClassLoader().getResourceAsStream("xslt/staff/staff.xml");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.sendBody(directStart, payloud);
        XsltEndpoint xsltEndpoint = null;
        for (int i = 0; i < 5 && (xsltEndpoint = this.resolveMandatoryEndpoint(endpointUri, XsltEndpoint.class)) == null; ++i) {
            Thread.sleep(50L);
        }
        this.assertMockEndpointsSatisfied();
        XsltUriResolverFactoryTest.assertNotNull(xsltEndpoint);
        CustomXsltUriResolver resolver = (CustomXsltUriResolver)((Object)xsltEndpoint.getUriResolver());
        this.checkResourceUri(resolver.resolvedRsourceUris, "xslt/staff/staff.xsl");
        this.checkResourceUri(resolver.resolvedRsourceUris, "../common/staff_template.xsl");
    }

    @Override
    protected RouteBuilder[] createRouteBuilders() throws Exception {
        return new RouteBuilder[]{new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").setHeader("xslt_file", (Expression)new ConstantExpression("xslt/staff/staff.xsl"))).recipientList((Expression)new SimpleExpression("xslt:${header.xslt_file}?uriResolverFactory=#uriResolverFactory")).to("mock:result");
            }
        }, new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:startComponent").setHeader("xslt_file", (Expression)new ConstantExpression("xslt/staff/staff.xsl"))).recipientList((Expression)new SimpleExpression("xslt:${header.xslt_file}")).to("mock:result");
            }
        }};
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        this.registry = super.createRegistry();
        this.registry.bind("uriResolverFactory", (Object)new CustomXsltUriResolverFactory());
        return this.registry;
    }

    void checkResourceUri(Set<String> uris, String resourceUri) {
        Assert.assertTrue((String)("Missing resource uri " + resourceUri + " in resolved resource URI set"), (boolean)uris.contains(resourceUri));
    }

    static class CustomXsltUriResolver
    extends XsltUriResolver {
        private final Set<String> resolvedRsourceUris = new HashSet<String>();

        CustomXsltUriResolver(ClassResolver resolver, String location) {
            super(resolver, location);
        }

        public Source resolve(String href, String base) throws TransformerException {
            Source result = super.resolve(href, base);
            this.resolvedRsourceUris.add(href);
            return result;
        }
    }

    static class CustomXsltUriResolverFactory
    implements XsltUriResolverFactory {
        CustomXsltUriResolverFactory() {
        }

        public URIResolver createUriResolver(CamelContext camelContext, String resourceUri) {
            return new CustomXsltUriResolver(camelContext.getClassResolver(), resourceUri);
        }
    }
}

