/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.MyBean;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultFactoryFinderResolver;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ReflectionInjector;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ConverterTest.class);
    protected TypeConverter converter = new DefaultTypeConverter((PackageScanClassResolver)new DefaultPackageScanClassResolver(), (Injector)new ReflectionInjector(), new DefaultFactoryFinderResolver().resolveDefaultFactoryFinder((ClassResolver)new DefaultClassResolver()));

    protected void setUp() throws Exception {
        PropertyEditorManager.registerEditor(Integer.class, IntegerPropertyEditor.class);
        ServiceHelper.startService((Object)this.converter);
    }

    public void testIntegerPropertyEditorConversion() throws Exception {
        Integer value = (Integer)this.converter.convertTo(Integer.class, (Object)"1000");
        ConverterTest.assertNotNull((Object)value);
        ConverterTest.assertEquals((String)"Converted to Integer", (Object)new Integer(1000), (Object)value);
        String text = (String)this.converter.convertTo(String.class, (Object)value);
        ConverterTest.assertEquals((String)"Converted to String", (String)"1000", (String)text);
    }

    public void testConvertStringToAndFromByteArray() throws Exception {
        byte[] array = (byte[])this.converter.convertTo(byte[].class, (Object)"foo");
        ConverterTest.assertNotNull((Object)array);
        LOG.debug("Found array of size: " + array.length);
        String text = (String)this.converter.convertTo(String.class, (Object)array);
        ConverterTest.assertEquals((String)"Converted to String", (String)"foo", (String)text);
    }

    public void testConvertStringToAndFromCharArray() throws Exception {
        char[] array = (char[])this.converter.convertTo(char[].class, (Object)"foo");
        ConverterTest.assertNotNull((Object)array);
        LOG.debug("Found array of size: " + array.length);
        String text = (String)this.converter.convertTo(String.class, (Object)array);
        ConverterTest.assertEquals((String)"Converted to String", (String)"foo", (String)text);
    }

    public void testConvertStringAndStreams() throws Exception {
        InputStream inputStream = (InputStream)this.converter.convertTo(InputStream.class, (Object)"bar");
        ConverterTest.assertNotNull((Object)inputStream);
        String text = (String)this.converter.convertTo(String.class, (Object)inputStream);
        ConverterTest.assertEquals((String)"Converted to String", (String)"bar", (String)text);
    }

    public void testArrayToListAndSetConversion() throws Exception {
        String[] array = new String[]{"one", "two"};
        List list = (List)this.converter.convertTo(List.class, (Object)array);
        ConverterTest.assertEquals((String)("List size: " + list), (int)2, (int)list.size());
        Collection collection = (Collection)this.converter.convertTo(Collection.class, (Object)array);
        ConverterTest.assertEquals((String)("Collection size: " + collection), (int)2, (int)collection.size());
        Set set = (Set)this.converter.convertTo(Set.class, (Object)array);
        ConverterTest.assertEquals((String)("Set size: " + set), (int)2, (int)set.size());
        set = (Set)this.converter.convertTo(Set.class, (Object)list);
        ConverterTest.assertEquals((String)("Set size: " + set), (int)2, (int)set.size());
    }

    public void testCollectionToArrayConversion() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        Object[] objectArray = (Object[])this.converter.convertTo(Object[].class, list);
        ConverterTest.assertEquals((String)"Object[] length", (int)2, (int)objectArray.length);
        String[] stringArray = (String[])this.converter.convertTo(String[].class, list);
        ConverterTest.assertEquals((String)"String[] length", (int)2, (int)stringArray.length);
    }

    public void testCollectionToPrimitiveArrayConversion() throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(5);
        list.add(6);
        Integer[] integerArray = (Integer[])this.converter.convertTo(Integer[].class, list);
        ConverterTest.assertEquals((String)"Integer[] length", (int)2, (int)integerArray.length);
        int[] intArray = (int[])this.converter.convertTo(int[].class, list);
        ConverterTest.assertEquals((String)"int[] length", (int)2, (int)intArray.length);
        long[] longArray = (long[])this.converter.convertTo(long[].class, (Object)intArray);
        ConverterTest.assertEquals((String)"long[] length", (int)2, (int)longArray.length);
        List resultList = (List)this.converter.convertTo(List.class, (Object)intArray);
        ConverterTest.assertEquals((String)"List size", (int)2, (int)resultList.size());
        LOG.debug("From primitive type array we've created the list: " + resultList);
    }

    public void testStringToFile() throws Exception {
        File file = (File)this.converter.convertTo(File.class, (Object)"foo.txt");
        ConverterTest.assertNotNull((Object)"Should have converted to a file!");
        ConverterTest.assertEquals((String)"file name", (String)"foo.txt", (String)file.getName());
    }

    public void testFileToString() throws Exception {
        URL resource = ((Object)((Object)this)).getClass().getResource("dummy.txt");
        ConverterTest.assertNotNull((String)"Cannot find resource!", (Object)resource);
        File file = new File(URLDecoder.decode(resource.getFile(), "UTF-8"));
        String text = (String)this.converter.convertTo(String.class, (Object)file);
        ConverterTest.assertNotNull((String)"Should have returned a String!", (Object)text);
        text = text.trim();
        ConverterTest.assertTrue((String)("Text not read correctly: " + text), (boolean)text.endsWith("Hello World!"));
    }

    public void testPrimitiveBooleanConversion() throws Exception {
        boolean value = (Boolean)this.converter.convertTo(Boolean.TYPE, null);
        ConverterTest.assertFalse((boolean)value);
    }

    public void testPrimitiveIntConversion() throws Exception {
        int value = (Integer)this.converter.convertTo(Integer.TYPE, (Object)4);
        ConverterTest.assertEquals((String)"value", (int)4, (int)value);
    }

    public void testPrimitiveIntPropertySetter() throws Exception {
        MyBean bean = new MyBean();
        IntrospectionSupport.setProperty((TypeConverter)this.converter, (Object)bean, (String)"foo", (Object)"4");
        ConverterTest.assertEquals((String)"bean.foo", (int)4, (int)bean.getFoo());
    }

    public void testStringToBoolean() throws Exception {
        Boolean value = (Boolean)this.converter.convertTo(Boolean.class, (Object)"true");
        ConverterTest.assertEquals((String)"converted boolean value", (Object)Boolean.TRUE, (Object)value);
        value = (Boolean)this.converter.convertTo(Boolean.class, (Object)"false");
        ConverterTest.assertEquals((String)"converted boolean value", (Object)Boolean.FALSE, (Object)value);
        value = (Boolean)this.converter.convertTo(Boolean.class, null);
        ConverterTest.assertEquals((String)"converted boolean value", null, (Object)value);
    }

    public void testStaticMethodConversionWithExchange() throws Exception {
        DefaultCamelContext camel = new DefaultCamelContext();
        DefaultExchange e = new DefaultExchange((CamelContext)camel);
        e.setProperty("prefix", (Object)"foo-");
        MyBean bean = (MyBean)this.converter.convertTo(MyBean.class, (Exchange)e, (Object)"5:bar");
        ConverterTest.assertEquals((String)"converted using exchange", (float)5.0f, (float)bean.getFoo(), (float)5.0f);
        ConverterTest.assertEquals((String)"converted using exchange", (String)"foo-bar", (String)bean.getBar());
    }

    public void testInstanceMethodConversionWithExchange() throws Exception {
        String[] values = new String[]{"5", "bar"};
        DefaultCamelContext camel = new DefaultCamelContext();
        DefaultExchange e = new DefaultExchange((CamelContext)camel);
        e.setProperty("prefix", (Object)"foo-");
        MyBean bean = (MyBean)this.converter.convertTo(MyBean.class, (Exchange)e, (Object)values);
        ConverterTest.assertEquals((String)"converted using exchange", (float)5.0f, (float)bean.getFoo(), (float)5.0f);
        ConverterTest.assertEquals((String)"converted using exchange", (String)"foo-bar", (String)bean.getBar());
    }

    public void testMandatoryConvertTo() {
        DefaultCamelContext camel = new DefaultCamelContext();
        DefaultExchange e = new DefaultExchange((CamelContext)camel);
        try {
            this.converter.mandatoryConvertTo(InputStream.class, (Object)e);
            ConverterTest.fail((String)"Expect exception here");
        }
        catch (Exception ex) {
            ConverterTest.assertTrue((String)"Expect to get a NoTypeConversionAvailableException here", (boolean)(ex instanceof NoTypeConversionAvailableException));
        }
    }

    public void testStringToChar() throws Exception {
        char ch = ((Character)this.converter.convertTo(Character.TYPE, (Object)"A")).charValue();
        ConverterTest.assertEquals((char)'A', (char)ch);
        ch = ((Character)this.converter.convertTo(Character.TYPE, (Object)" ")).charValue();
        ConverterTest.assertEquals((char)' ', (char)ch);
        try {
            this.converter.mandatoryConvertTo(Character.TYPE, (Object)"ABC");
            ConverterTest.fail((String)"Should have thrown an exception");
        }
        catch (TypeConversionException e) {
            ConverterTest.assertEquals((String)"java.lang.IllegalArgumentException: String must have exactly a length of 1: ABC", (String)e.getCause().getMessage());
        }
    }

    public static class IntegerPropertyEditor
    extends PropertyEditorSupport {
        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            this.setValue(new Integer(text));
        }

        @Override
        public String getAsText() {
            Integer value = (Integer)this.getValue();
            return value != null ? value.toString() : "";
        }
    }
}

