/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;
import org.apache.camel.StringSource;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.impl.DefaultFactoryFinderResolver;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ReflectionInjector;
import org.apache.camel.util.ServiceHelper;

public class StringSourceTest
extends TestCase {
    protected TypeConverter converter = new DefaultTypeConverter((PackageScanClassResolver)new DefaultPackageScanClassResolver(), (Injector)new ReflectionInjector(), new DefaultFactoryFinderResolver().resolveDefaultFactoryFinder((ClassResolver)new DefaultClassResolver()));
    protected String expectedBody = "<hello>world!</hello>";

    protected void setUp() throws Exception {
        super.setUp();
        ServiceHelper.startService((Object)this.converter);
    }

    public void testSerialization() throws Exception {
        StringSource expected = new StringSource(this.expectedBody, "mySystemID", "utf-8");
        expected.setPublicId("myPublicId");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream output = new ObjectOutputStream(buffer);
        output.writeObject(expected);
        output.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        Object object = in.readObject();
        StringSourceTest.assertTrue((String)"is a StringSource", (boolean)(object instanceof StringSource));
        StringSource actual = (StringSource)object;
        StringSourceTest.assertEquals((String)"source.text", (String)expected.getPublicId(), (String)actual.getPublicId());
        StringSourceTest.assertEquals((String)"source.text", (String)expected.getSystemId(), (String)actual.getSystemId());
        StringSourceTest.assertEquals((String)"source.text", (String)expected.getEncoding(), (String)actual.getEncoding());
        StringSourceTest.assertEquals((String)"source.text", (String)expected.getText(), (String)actual.getText());
        String value = (String)this.converter.convertTo(String.class, (Object)actual);
        StringSourceTest.assertEquals((String)"text value of StringSource", (String)this.expectedBody, (String)value);
    }
}

