/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerDrivenTimePatternConverterTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TimerDrivenTimePatternConverterTest.class);

    public void testTimerInvocation() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        this.assertMockEndpointsSatisfied();
    }

    public void testTimerUsingStopWatch() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        StopWatch watch = new StopWatch();
        this.assertMockEndpointsSatisfied();
        long interval = watch.stop();
        LOG.trace("Should take approx 2000 milliseconds, was: {}", (Object)interval);
        TimerDrivenTimePatternConverterTest.assertTrue((String)("Should take approx 2000 milliseconds, was: " + interval), (interval >= 1700L ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                this.from("timer://foo?fixedRate=true&delay=0&period=2s").to("mock:result");
            }
        };
    }
}

