/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Consume;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.CamelPostProcessorHelper;

public class CamelPostProcessorHelperConsumePropertyTest
extends ContextTestSupport {
    public void testConsumePropertyExplicit() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeBean my = new MyConsumeBean();
        my.setFoo("seda:foo");
        Method method = my.getClass().getMethod("consumeSomething", String.class);
        helper.consumerInjection(method, (Object)my, "foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testConsumePropertyImplicit() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeBean my = new MyConsumeBean();
        my.setFoo("seda:foo");
        Method method = my.getClass().getMethod("foo", String.class);
        helper.consumerInjection(method, (Object)my, "foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testConsumePropertyOnImplicit() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeBean my = new MyConsumeBean();
        my.setFoo("seda:foo");
        Method method = my.getClass().getMethod("onFoo", String.class);
        helper.consumerInjection(method, (Object)my, "foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testConsumePropertyEndpointImplicit() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeBean my = new MyConsumeBean();
        my.setBarEndpoint("seda:bar");
        Method method = my.getClass().getMethod("bar", String.class);
        helper.consumerInjection(method, (Object)my, "bar");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testConsumePropertyOnEndpointImplicit() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeBean my = new MyConsumeBean();
        my.setBarEndpoint("seda:bar");
        Method method = my.getClass().getMethod("onBar", String.class);
        helper.consumerInjection(method, (Object)my, "bar");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public class MyConsumeBean {
        private String foo;
        private String barEndpoint;

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String getBarEndpoint() {
            return this.barEndpoint;
        }

        public void setBarEndpoint(String barEndpoint) {
            this.barEndpoint = barEndpoint;
        }

        @Consume(property="foo")
        public void consumeSomething(String body) {
            TestCase.assertEquals((String)"Hello World", (String)body);
            CamelPostProcessorHelperConsumePropertyTest.this.template.sendBody("mock:result", (Object)body);
        }

        @Consume
        public void foo(String body) {
            TestCase.assertEquals((String)"Hello World", (String)body);
            CamelPostProcessorHelperConsumePropertyTest.this.template.sendBody("mock:result", (Object)body);
        }

        @Consume
        public void onFoo(String body) {
            TestCase.assertEquals((String)"Hello World", (String)body);
            CamelPostProcessorHelperConsumePropertyTest.this.template.sendBody("mock:result", (Object)body);
        }

        @Consume
        public void bar(String body) {
            TestCase.assertEquals((String)"Hello World", (String)body);
            CamelPostProcessorHelperConsumePropertyTest.this.template.sendBody("mock:result", (Object)body);
        }

        @Consume
        public void onBar(String body) {
            TestCase.assertEquals((String)"Hello World", (String)body);
            CamelPostProcessorHelperConsumePropertyTest.this.template.sendBody("mock:result", (Object)body);
        }
    }
}

