/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.NodeIdFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomIdFactoryTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CustomIdFactoryTest.class);
    private static int counter;
    private static String ids;

    @Override
    protected void setUp() throws Exception {
        ids = "";
        counter = 0;
        super.setUp();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                CustomIdFactoryTest.this.context.setNodeIdFactory(new NodeIdFactory(){

                    public String createId(NamedNode definition) {
                        return "#" + definition.getShortName() + ++counter + "#";
                    }
                });
                CustomIdFactoryTest.this.context.addInterceptStrategy((InterceptStrategy)new MyDebuggerCheckingId());
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().contains((Object)"Hello")).to("mock:hello")).otherwise().log("Hey")).to("mock:other")).end();
            }
        };
    }

    public void testHello() throws Exception {
        CustomIdFactoryTest.assertEquals((String)"#route1#", (String)((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId());
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        CustomIdFactoryTest.assertEquals((String)"#choice7##to2#", (String)ids);
    }

    public void testOther() throws Exception {
        CustomIdFactoryTest.assertEquals((String)"#route1#", (String)((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId());
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        CustomIdFactoryTest.assertEquals((String)"#choice7##log4##to6#", (String)ids);
    }

    private static class MyDebuggerCheckingId
    implements InterceptStrategy {
        private MyDebuggerCheckingId() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, final ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
            definition.idOrCreate(context.getNodeIdFactory());
            return new DelegateProcessor(target){

                protected void processNext(Exchange exchange) throws Exception {
                    LOG.debug("Debugging at: " + definition.toString() + " with id: " + definition.getId() + " with exchange: " + exchange);
                    ids = ids + definition.getId();
                    super.processNext(exchange);
                }
            };
        }
    }
}

