/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;

public class DefaultMessageHeaderTest
extends TestCase {
    public void testLookupCaseAgnostic() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("Foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("FOO"));
    }

    public void testLookupCaseAgnosticAddHeader() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("Foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("FOO"));
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("unknown"));
        msg.setHeader("bar", (Object)"beer");
        DefaultMessageHeaderTest.assertEquals((Object)"beer", (Object)msg.getHeader("bar"));
        DefaultMessageHeaderTest.assertEquals((Object)"beer", (Object)msg.getHeader("Bar"));
        DefaultMessageHeaderTest.assertEquals((Object)"beer", (Object)msg.getHeader("BAR"));
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("unknown"));
    }

    public void testLookupCaseAgnosticAddHeader2() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("FOO"));
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("Foo"));
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("unknown"));
        msg.setHeader("bar", (Object)"beer");
        DefaultMessageHeaderTest.assertEquals((Object)"beer", (Object)msg.getHeader("BAR"));
        DefaultMessageHeaderTest.assertEquals((Object)"beer", (Object)msg.getHeader("bar"));
        DefaultMessageHeaderTest.assertEquals((Object)"beer", (Object)msg.getHeader("Bar"));
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("unknown"));
    }

    public void testLookupCaseAgnosticAddHeaderRemoveHeader() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("Foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("FOO"));
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("unknown"));
        msg.setHeader("bar", (Object)"beer");
        DefaultMessageHeaderTest.assertEquals((Object)"beer", (Object)msg.getHeader("bar"));
        DefaultMessageHeaderTest.assertEquals((Object)"beer", (Object)msg.getHeader("Bar"));
        DefaultMessageHeaderTest.assertEquals((Object)"beer", (Object)msg.getHeader("BAR"));
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("unknown"));
        msg.removeHeader("bar");
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("bar"));
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("unknown"));
    }

    public void testSetWithDifferentCase() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        msg.setHeader("Foo", (Object)"bar");
        DefaultMessageHeaderTest.assertEquals((Object)"bar", (Object)msg.getHeader("FOO"));
        DefaultMessageHeaderTest.assertEquals((Object)"bar", (Object)msg.getHeader("foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"bar", (Object)msg.getHeader("Foo"));
    }

    public void testRemoveWithDifferentCase() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        msg.setHeader("Foo", (Object)"bar");
        DefaultMessageHeaderTest.assertEquals((Object)"bar", (Object)msg.getHeader("FOO"));
        DefaultMessageHeaderTest.assertEquals((Object)"bar", (Object)msg.getHeader("foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"bar", (Object)msg.getHeader("Foo"));
        msg.removeHeader("FOO");
        DefaultMessageHeaderTest.assertEquals(null, (Object)msg.getHeader("foo"));
        DefaultMessageHeaderTest.assertEquals(null, (Object)msg.getHeader("Foo"));
        DefaultMessageHeaderTest.assertEquals(null, (Object)msg.getHeader("FOO"));
        DefaultMessageHeaderTest.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    public void testRemoveHeaderWithNullValue() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", null);
        msg.removeHeader("tick");
        DefaultMessageHeaderTest.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    public void testRemoveHeadersWithWildcard() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        DefaultMessageHeaderTest.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
        msg.removeHeaders("t*");
        DefaultMessageHeaderTest.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    public void testRemoveHeadersAllWithWildcard() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        DefaultMessageHeaderTest.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
        msg.removeHeaders("*");
        DefaultMessageHeaderTest.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    public void testRemoveHeadersWithExclude() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tiack", (Object)"blaa");
        msg.setHeader("tiock", (Object)"blaaa");
        msg.setHeader("tiuck", (Object)"blaaaa");
        msg.removeHeaders("ti*", new String[]{"tiuck", "tiack"});
        DefaultMessageHeaderTest.assertEquals((int)2, (int)msg.getHeaders().size());
        DefaultMessageHeaderTest.assertEquals((Object)"blaa", (Object)msg.getHeader("tiack"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaaaa", (Object)msg.getHeader("tiuck"));
    }

    public void testRemoveHeadersAllWithExclude() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        DefaultMessageHeaderTest.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
        msg.removeHeaders("*", new String[]{"tick", "tock", "toe"});
        DefaultMessageHeaderTest.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        DefaultMessageHeaderTest.assertEquals(null, (Object)msg.getHeader("tack"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
    }

    public void testRemoveHeadersWithWildcardInExclude() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("taick", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        msg.removeHeaders("*", new String[]{"ta*"});
        DefaultMessageHeaderTest.assertEquals((int)2, (int)msg.getHeaders().size());
        DefaultMessageHeaderTest.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaa", (Object)msg.getHeader("taick"));
    }

    public void testRemoveHeadersWithNulls() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        msg.setHeader("taack", (Object)"blaaaa");
        DefaultMessageHeaderTest.assertEquals((Object)"bla", (Object)msg.getHeader("tick"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaa", (Object)msg.getHeader("tack"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaaa", (Object)msg.getHeader("tock"));
        DefaultMessageHeaderTest.assertEquals((Object)"blaaaa", (Object)msg.getHeader("taack"));
        msg.removeHeaders(null, new String[]{null, null, null});
        DefaultMessageHeaderTest.assertFalse((boolean)msg.getHeaders().isEmpty());
    }

    public void testRemoveHeadersWithNonExcludeHeaders() {
        DefaultMessage msg = new DefaultMessage();
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("tick", (Object)"bla");
        msg.setHeader("tack", (Object)"blaa");
        msg.setHeader("tock", (Object)"blaaa");
        msg.removeHeaders("*", new String[]{"camels", "are", "fun"});
        DefaultMessageHeaderTest.assertTrue((boolean)msg.getHeaders().isEmpty());
    }

    public void testWithDefaults() {
        DefaultMessage msg = new DefaultMessage();
        msg.setExchange((Exchange)new DefaultExchange((CamelContext)new DefaultCamelContext()));
        DefaultMessageHeaderTest.assertNull((Object)msg.getHeader("foo"));
        msg.setHeader("foo", (Object)"cheese");
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("foo"));
        DefaultMessageHeaderTest.assertEquals((Object)"cheese", (Object)msg.getHeader("foo", (Object)"foo"));
        DefaultMessageHeaderTest.assertEquals((String)"cheese", (String)((String)msg.getHeader("foo", (Object)"foo", String.class)));
        DefaultMessageHeaderTest.assertEquals(null, (Object)msg.getHeader("beer"));
        DefaultMessageHeaderTest.assertEquals((Object)"foo", (Object)msg.getHeader("beer", (Object)"foo"));
        DefaultMessageHeaderTest.assertEquals((Object)123, (Object)msg.getHeader("beer", (Object)"123", Integer.class));
    }
}

