/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FromEndpointTest
extends ContextTestSupport {
    private MockEndpoint results;
    private Object expectedBody = "<hello>world!</hello>";

    public void testReceivedMessageHasFromEndpointSet() throws Exception {
        this.results = this.getMockEndpoint("mock:results");
        this.results.expectedBodiesReceived(new Object[]{this.expectedBody});
        this.template.sendBody("direct:start", this.expectedBody);
        this.results.assertIsSatisfied();
        List list = this.results.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        Endpoint fromEndpoint = exchange.getFromEndpoint();
        FromEndpointTest.assertNotNull((String)"exchange.fromEndpoint() is null!", (Object)fromEndpoint);
        FromEndpointTest.assertEquals((String)"fromEndpoint URI", (String)"direct://start", (String)fromEndpoint.getEndpointUri());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:results");
            }
        };
    }
}

