/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.converter.IOConverter;

public class GzipDataFormatTest
extends ContextTestSupport {
    private static final String TEXT = "Hamlet by William Shakespeare\nTo be, or not to be: that is the question:\nWhether 'tis nobler in the mind to suffer\nThe slings and arrows of outrageous fortune,\nOr to take arms against a sea of troubles,\nAnd by opposing end them? To die: to sleep;";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private byte[] sendText() throws Exception {
        return (byte[])this.template.requestBody("direct:start", (Object)TEXT.getBytes("UTF-8"));
    }

    public void testMarshalTextToGZip() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().gzip();
            }
        });
        this.context.start();
        byte[] output = this.sendText();
        GZIPInputStream stream = new GZIPInputStream(new ByteArrayInputStream(output));
        String result = IOConverter.toString((InputStream)stream, null);
        GzipDataFormatTest.assertEquals((String)"Uncompressed something different than compressed", (String)TEXT, (String)result);
    }

    public void testUnMarshalTextToGzip() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().gzip().unmarshal().gzip().to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint result = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        result.expectedBodiesReceived(new Object[]{TEXT.getBytes("UTF-8")});
        this.sendText();
        result.assertIsSatisfied();
    }
}

