/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.InterceptSendToMockEndpointStrategy;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EndpointStrategy;

public class InterceptSendToMockEndpointStrategyCustomTest
extends ContextTestSupport {
    private static boolean called;

    public void testAdvisedMockEndpoints() throws Exception {
        this.context.addRegisterEndpointCallback((EndpointStrategy)new MyStrategy());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("direct:foo")).to("log:foo")).to("mock:result");
                this.from("direct:foo").transform((Expression)this.constant("Bye World"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:direct:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:direct:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:log:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        InterceptSendToMockEndpointStrategyCustomTest.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        InterceptSendToMockEndpointStrategyCustomTest.assertNotNull((Object)this.context.hasEndpoint("direct:foo"));
        InterceptSendToMockEndpointStrategyCustomTest.assertNotNull((Object)this.context.hasEndpoint("log:foo"));
        InterceptSendToMockEndpointStrategyCustomTest.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        InterceptSendToMockEndpointStrategyCustomTest.assertNotNull((Object)this.context.hasEndpoint("mock:direct:start"));
        InterceptSendToMockEndpointStrategyCustomTest.assertNotNull((Object)this.context.hasEndpoint("mock:direct:foo"));
        InterceptSendToMockEndpointStrategyCustomTest.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
        InterceptSendToMockEndpointStrategyCustomTest.assertTrue((String)"Should be called", (boolean)called);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private class MyStrategy
    extends InterceptSendToMockEndpointStrategy {
        private MyStrategy() {
        }

        protected Producer onInterceptEndpoint(String uri, Endpoint endpoint, MockEndpoint mockEndpoint, Producer mockProducer) {
            called = true;
            return mockProducer;
        }
    }
}

