/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.spi.Language;
import org.apache.camel.util.jndi.JndiTest;

public class JndiRegistryTest
extends TestCase {
    public void testLookupByType() throws Exception {
        JndiRegistry jndi = new JndiRegistry(JndiTest.createInitialContext());
        jndi.bind("foo", (Object)new SimpleLanguage());
        jndi.bind("bar", (Object)"Hello bar");
        JndiRegistryTest.assertEquals((Object)"Hello bar", (Object)jndi.lookup("bar"));
        JndiRegistryTest.assertEquals((Object)"Hello bar", (Object)jndi.lookupByName("bar"));
        JndiRegistryTest.assertEquals((String)"Hello bar", (String)((String)jndi.lookupByNameAndType("bar", String.class)));
        JndiRegistryTest.assertNull((Object)jndi.lookup("unknown"));
        JndiRegistryTest.assertNull((Object)jndi.lookupByName("unknown"));
        try {
            JndiRegistryTest.assertNull((Object)jndi.lookupByNameAndType("bar", Language.class));
            JndiRegistryTest.fail((String)"Should throw exception");
        }
        catch (NoSuchBeanException noSuchBeanException) {
            // empty catch block
        }
        JndiRegistryTest.assertNotNull((Object)jndi.lookupByNameAndType("foo", Language.class));
        JndiRegistryTest.assertNotNull((Object)jndi.lookupByNameAndType("foo", SimpleLanguage.class));
        JndiRegistryTest.assertSame((Object)jndi.lookupByNameAndType("foo", Language.class), (Object)jndi.lookupByNameAndType("foo", SimpleLanguage.class));
        Map set = jndi.lookupByType(Language.class);
        JndiRegistryTest.assertNotNull((Object)set);
        JndiRegistryTest.assertEquals((int)1, (int)set.size());
        String key = (String)set.keySet().iterator().next();
        JndiRegistryTest.assertEquals((String)"foo", (String)key);
        JndiRegistryTest.assertSame((Object)jndi.lookupByName("foo"), set.values().iterator().next());
    }

    public void testStandalone() throws Exception {
        JndiRegistry jndi = new JndiRegistry(true);
        jndi.bind("bar", (Object)"Hello bar");
        JndiRegistryTest.assertEquals((Object)"Hello bar", (Object)jndi.lookup("bar"));
    }

    public void testCamelContextFactory() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("java.naming.factory.initial", "org.apache.camel.util.jndi.CamelInitialContextFactory");
        JndiRegistry jndi = new JndiRegistry(env);
        jndi.bind("bar", (Object)"Hello bar");
        JndiRegistryTest.assertEquals((Object)"Hello bar", (Object)jndi.lookup("bar"));
    }
}

