/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.Language;

public class LanguageCamelContextAwareTest
extends ContextTestSupport {
    private MyLanguage my = new MyLanguage();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("my", (Object)this.my);
        return jndi;
    }

    public void testLanguageCamelContextAware() throws Exception {
        Language lan = this.context.resolveLanguage("my");
        LanguageCamelContextAwareTest.assertNotNull((Object)lan);
        MyLanguage me = LanguageCamelContextAwareTest.assertIsInstanceOf(MyLanguage.class, lan);
        LanguageCamelContextAwareTest.assertNotNull((Object)me.getCamelContext());
    }

    private static class MyLanguage
    implements Language,
    CamelContextAware {
        private CamelContext camelContext;

        private MyLanguage() {
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public Predicate createPredicate(String expression) {
            return null;
        }

        public Expression createExpression(String expression) {
            return null;
        }
    }
}

