/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.TraceExchangeFormatter;
import org.apache.camel.model.RouteDefinition;

public class LogDebugBodyMaxCharsTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.context.getProperties().put("CamelLogDebugBodyMaxChars", "20");
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("logFormatter", (Object)new TraceExchangeFormatter());
        return jndi;
    }

    public void testLogBodyMaxLengthTest() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            int value = i % 10;
            sb.append(value);
        }
        String body = sb.toString();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        LogDebugBodyMaxCharsTest.assertTrue((boolean)msg.endsWith("Body: 01234567890123456789... [Body clipped after 20 chars, total length is 1000]]"));
        LogDebugBodyMaxCharsTest.assertNotSame((String)"clipped log and real body should not be the same", (Object)msg, (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(String.class));
    }

    public void testNotClipped() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"1234567890");
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        LogDebugBodyMaxCharsTest.assertTrue((boolean)msg.endsWith("Body: 1234567890]"));
        LogDebugBodyMaxCharsTest.assertNotSame((String)"clipped log and real body should not be the same", (Object)msg, (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(String.class));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

