/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.StringSource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.TraceExchangeFormatter;
import org.apache.camel.model.RouteDefinition;

public class LogDebugBodyStreamsTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("logFormatter", (Object)new TraceExchangeFormatter());
        return jndi;
    }

    public void testLogBodyStreamStringSourceDisabled() throws Exception {
        this.context.getProperties().put("CamelLogDebugStreams", "false");
        StringSource body = new StringSource("<?xml version=\"1.0\"?><person><name>Claus</name></person>");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        LogDebugBodyStreamsTest.assertTrue((boolean)msg.endsWith("Body: <?xml version=\"1.0\"?><person><name>Claus</name></person>]"));
    }

    public void testLogBodyStreamStringSourceDisabledByDefault() throws Exception {
        this.context.getProperties().remove("CamelLogDebugStreams");
        StringSource body = new StringSource("<?xml version=\"1.0\"?><person><name>Claus</name></person>");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        LogDebugBodyStreamsTest.assertTrue((boolean)msg.endsWith("Body: <?xml version=\"1.0\"?><person><name>Claus</name></person>]"));
    }

    public void testLogBodyStreamStringSourceEnabled() throws Exception {
        this.context.getProperties().put("CamelLogDebugStreams", "true");
        StringSource body = new StringSource("<?xml version=\"1.0\"?><person><name>Claus</name></person>");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        LogDebugBodyStreamsTest.assertTrue((boolean)msg.endsWith("Body: <?xml version=\"1.0\"?><person><name>Claus</name></person>]"));
    }

    public void testLogBodyStreamDisabled() throws Exception {
        this.context.getProperties().put("CamelLogDebugStreams", "false");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello World".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        LogDebugBodyStreamsTest.assertTrue((boolean)msg.endsWith("Body: [Body is instance of java.io.InputStream]]"));
    }

    public void testLogBodyStreamDisabledByDefault() throws Exception {
        this.context.getProperties().remove("CamelLogDebugStreams");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello World".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        LogDebugBodyStreamsTest.assertTrue((boolean)msg.endsWith("Body: [Body is instance of java.io.InputStream]]"));
    }

    public void testLogBodyStreamEnabled() throws Exception {
        this.context.getProperties().put("CamelLogDebugStreams", "true");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello World".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        LogDebugBodyStreamsTest.assertTrue((boolean)msg.endsWith("Body: [Body is instance of java.io.InputStream]]"));
        LogDebugBodyStreamsTest.assertIsInstanceOf(InputStream.class, ((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

