/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;

public class RouteRemove2Test
extends ContextTestSupport {
    public void testRemove() throws Exception {
        DefaultCamelContext defaultContext = (DefaultCamelContext)this.context;
        RouteRemove2Test.assertEquals((String)"2 routes to start with", (int)2, (int)this.context.getRoutes().size());
        RouteRemove2Test.assertEquals((String)"2 routes to start with", (int)2, (int)this.context.getRouteDefinitions().size());
        RouteRemove2Test.assertEquals((String)"2 routes to start with", (int)2, (int)defaultContext.getRouteStartupOrder().size());
        RouteRemove2Test.assertEquals((String)"2 routes to start with", (int)2, (int)defaultContext.getRouteServices().size());
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        RouteRemove2Test.assertEquals((String)"Started", (String)this.context.getRouteStatus("foo").name());
        RouteRemove2Test.assertEquals((String)"Started", (String)this.context.getRouteStatus("bar").name());
        this.context.stopRoute("foo");
        RouteRemove2Test.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
        RouteRemove2Test.assertEquals((String)"Started", (String)this.context.getRouteStatus("bar").name());
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("seda:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.removeRoute("foo");
        RouteRemove2Test.assertEquals((String)"There should be no foo route anymore", null, (Object)this.context.getRouteStatus("foo"));
        RouteRemove2Test.assertEquals((String)"Started", (String)this.context.getRouteStatus("bar").name());
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("seda:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        RouteRemove2Test.assertEquals((String)"1 routes to end with", (int)1, (int)this.context.getRoutes().size());
        RouteRemove2Test.assertEquals((String)"1 routes to end with", (int)1, (int)this.context.getRouteDefinitions().size());
        RouteRemove2Test.assertEquals((String)"1 routes to end with", (int)1, (int)defaultContext.getRouteStartupOrder().size());
        RouteRemove2Test.assertEquals((String)"1 routes to end with", (int)1, (int)defaultContext.getRouteServices().size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("seda:bar")).to("mock:foo");
                this.from("seda:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

