/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverterExistsException;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.TypeConverterSupport;

public class TypeConverterRegistryTest
extends TestCase {
    public void testDefaultTypeConverterRegistry() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        TypeConverterRegistryTest.assertNotNull((Object)ctx.getTypeConverterRegistry());
        TypeConverter tc = ctx.getTypeConverterRegistry().lookup(InputStream.class, File.class);
        TypeConverterRegistryTest.assertNotNull((Object)tc);
    }

    public void testAddTypeConverter() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        MyOrder order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        TypeConverterRegistryTest.assertNotNull((Object)order);
        TypeConverterRegistryTest.assertEquals((int)123, (int)order.getId());
    }

    public void testAddDuplicateTypeConverter() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
    }

    public void testAddDuplicateTypeConverterIgnore() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().setTypeConverterExists(TypeConverterExists.Ignore);
        context.getTypeConverterRegistry().setTypeConverterExistsLoggingLevel(LoggingLevel.INFO);
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
    }

    public void testAddDuplicateTypeConverterFail() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().setTypeConverterExists(TypeConverterExists.Fail);
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        try {
            context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
            TypeConverterRegistryTest.fail((String)"Should have thrown exception");
        }
        catch (TypeConverterExistsException typeConverterExistsException) {
            // empty catch block
        }
    }

    public void testRemoveTypeConverter() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        MyOrder order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        TypeConverterRegistryTest.assertNotNull((Object)order);
        TypeConverterRegistryTest.assertEquals((int)123, (int)order.getId());
        boolean removed = context.getTypeConverterRegistry().removeTypeConverter(MyOrder.class, String.class);
        TypeConverterRegistryTest.assertTrue((String)"Type converter should be removed", (boolean)removed);
        order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        TypeConverterRegistryTest.assertNull((String)"Type converter should be removed", (Object)order);
    }

    private static class MyOrderTypeConverter
    extends TypeConverterSupport {
        private MyOrderTypeConverter() {
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
            MyOrder order = new MyOrder();
            order.setId(Integer.parseInt(value.toString()));
            return (T)order;
        }
    }

    private static class MyOrder {
        private int id;

        private MyOrder() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

