/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithInterceptSendToEndpointWithLoadbalancerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testInterceptSendToEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").loadBalance().failover().to(new String[]{"seda:end1", "seda:end2"});
            }
        });
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        route.adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("seda:end1").skipSendToOriginalEndpoint().to("mock:end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

