/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class CBRCustomPredicateAsFilterTest
extends ContextTestSupport {
    private MyFiler filter = new MyFiler();

    public void testCBRCustomPredicateAsFilter() throws Exception {
        this.getMockEndpoint("mock:good").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:secret").expectedBodiesReceived(new Object[]{"secret"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"secret");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        CBRCustomPredicateAsFilterTest.assertEquals((String)"Hello World", (String)this.filter.getBodies().get(0));
        CBRCustomPredicateAsFilterTest.assertEquals((String)"secret", (String)this.filter.getBodies().get(1));
        CBRCustomPredicateAsFilterTest.assertEquals((String)"Bye World", (String)this.filter.getBodies().get(2));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)CBRCustomPredicateAsFilterTest.this.filter).to("mock:good")).otherwise().to("mock:secret");
            }
        };
    }

    private static class MyFiler
    implements Predicate {
        private List<String> bodies = new ArrayList<String>();

        private MyFiler() {
        }

        public boolean matches(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            this.bodies.add(body);
            return !"secret".equals(body);
        }

        public List<String> getBodies() {
            return this.bodies;
        }
    }
}

