/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class ChangeHeaderCaseIssueTest
extends ContextTestSupport {
    public void testChangeHeaderCaseIssue() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("SoapAction", (Object)"cool");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "SOAPAction", (Object)"cool");
        this.assertMockEndpointsSatisfied();
        HashMap headers = new HashMap(((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeaders());
        ChangeHeaderCaseIssueTest.assertEquals((Object)"cool", headers.get("SoapAction"));
        ChangeHeaderCaseIssueTest.assertEquals(null, headers.get("SOAPAction"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock:result").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Object value = exchange.getIn().removeHeader("SOAPAction");
                        exchange.getIn().setHeader("SoapAction", value);
                    }
                });
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

