/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DavidSiefertTest
extends ContextTestSupport {
    protected static Object expectedBody = "Some Output";

    public void testWorks() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        result.expectedBodiesReceived(new Object[]{expectedBody});
        ((ValueBuilder)result.message(0).header("sample.name")).isEqualTo((Object)"myValue");
        this.template.sendBody("direct:start", (Object)"<sample><name>value</name></sample>");
        result.assertIsSatisfied();
    }

    public void testHeaderPredicateFails() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        ((ValueBuilder)result.message(0).header("sample.name")).isEqualTo((Object)"shouldNotMatch");
        this.template.sendBody("direct:start", (Object)"<sample><name>value</name></sample>");
        try {
            result.assertIsSatisfied();
            DavidSiefertTest.fail((String)"Should have failed this test!");
        }
        catch (AssertionError e) {
            this.log.info("Caught expected assertion failure: " + e, (Throwable)((Object)e));
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            exchange.getIn().getBody(String.class);
            Message output = exchange.getOut();
            output.setHeader("sample.name", (Object)"myValue");
            output.setBody(expectedBody);
        }
    }
}

