/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class Issue170Test
extends ContextTestSupport {
    protected String qOne = "seda:Q1";
    protected String qTwo = "mock:Q2";
    protected String qThree = "mock:Q3";

    public void testSendMessagesGetCorrectCounts() throws Exception {
        MockEndpoint q2 = this.getMockEndpoint(this.qTwo);
        MockEndpoint q3 = this.getMockEndpoint(this.qThree);
        String body1 = "<message id='1'/>";
        String body2 = "<message id='2'/>";
        q2.expectedBodiesReceived(new Object[]{body1, body2});
        q3.expectedBodiesReceived(new Object[]{body1, body2});
        this.template.sendBodyAndHeader("direct:start", (Object)body1, "counter", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)body2, "counter", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to(Issue170Test.this.qOne);
                this.from(Issue170Test.this.qOne).to(new String[]{Issue170Test.this.qTwo, Issue170Test.this.qThree});
            }
        };
    }
}

