/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class OnExceptionContinuedIssueTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testOnExceptionWrappedMatch() throws Exception {
        DeadLetterChannelBuilder defaultErrorHandlerBuilder = new DeadLetterChannelBuilder("direct:dead");
        defaultErrorHandlerBuilder.redeliveryDelay(0L);
        defaultErrorHandlerBuilder.maximumRedeliveries(2);
        this.context.setErrorHandlerBuilder((ErrorHandlerFactory)defaultErrorHandlerBuilder);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                OnExceptionContinuedIssueTest.this.context.setTracing(Boolean.valueOf(false));
                this.onException(OrderFailedException.class).maximumRedeliveries(0).continued(true);
                this.from("direct:dead").to(new String[]{"log:dead", "mock:dead"});
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:order").to("mock:one")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        log.info("First Processor Invoked");
                        throw new OrderFailedException("First Processor Failure");
                    }
                })).to("mock:two")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        log.info("Second Processor Invoked");
                    }
                })).to("mock:three")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        log.info("Third Processor Invoked");
                        throw new RuntimeException("Some Runtime Exception");
                    }
                })).to("mock:four")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        log.info("Fourth Processor Invoked");
                    }
                });
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.getMockEndpoint("mock:one").expectedMessageCount(1);
        this.getMockEndpoint("mock:two").expectedMessageCount(1);
        this.getMockEndpoint("mock:three").expectedMessageCount(1);
        this.getMockEndpoint("mock:four").expectedMessageCount(0);
        this.template.requestBody("direct:order", (Object)"Camel in Action");
        this.assertMockEndpointsSatisfied();
    }

    public class OrderFailedException
    extends Exception {
        public OrderFailedException(String s) {
            super(s);
        }
    }
}

