/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnExceptionDefinition;

public class OnExceptionNotHandledErrorHandlerRefIssueTest
extends ContextTestSupport {
    public void testOnExceptionErrorHandlerRef() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            OnExceptionNotHandledErrorHandlerRefIssueTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = OnExceptionNotHandledErrorHandlerRefIssueTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            OnExceptionNotHandledErrorHandlerRefIssueTest.assertEquals((String)"Damn", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myDLC", (Object)new DeadLetterChannelBuilder("mock:dead"));
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)new ErrorHandlerBuilderRef("myDLC"));
                ((OnExceptionDefinition)this.from("direct:start").onException(IllegalArgumentException.class).handled(false).to("mock:handled")).end().to("mock:a").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

