/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.FileNotFoundException;
import java.net.ConnectException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class RouteScopedErrorHandlerAndOnExceptionTest
extends ContextTestSupport {
    public void testOnException() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        route.adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().throwException((Exception)new ConnectException("Forced"));
            }
        });
        this.getMockEndpoint("mock:local").expectedMessageCount(0);
        this.getMockEndpoint("mock:seda").expectedMessageCount(0);
        this.getMockEndpoint("mock:exhausted").expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            RouteScopedErrorHandlerAndOnExceptionTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            ConnectException cause = RouteScopedErrorHandlerAndOnExceptionTest.assertIsInstanceOf(ConnectException.class, e.getCause());
            RouteScopedErrorHandlerAndOnExceptionTest.assertEquals((String)"Forced", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testErrorHandler() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        route.adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().throwException((Exception)new FileNotFoundException("Forced"));
            }
        });
        this.getMockEndpoint("mock:local").expectedMessageCount(1);
        this.getMockEndpoint("mock:seda").expectedMessageCount(0);
        this.getMockEndpoint("mock:exhausted").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:local").maximumRedeliveries(2).redeliveryDelay(0L)).onException(ConnectException.class).maximumRedeliveries(5).redeliveryDelay(0L).logRetryAttempted(true).retryAttemptedLogLevel(LoggingLevel.WARN).to("mock:exhausted")).end().to("seda:foo");
            }
        };
    }
}

